package com.introtoandroid.samples.simplepreferences;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import android.view.Menu;
import android.view.MenuItem;

public abstract class SuperSimplePreferencesActivity extends Activity {
    public static final String PREFERENCE_FILENAME = "AppPrefs";
    public static final String PREFERENCE_STRING_NAME = "StringPrefActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_simple_preferences);

        // Dzielimy bieżącą preferencję.
        SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
        SharedPreferences settingsActivity = getPreferences(MODE_PRIVATE);

        // Wyświeltamy nazwę aktywności.
        final TextView activityName = (TextView)findViewById(R.id.Title);
        String localClassName = this.getLocalClassName();
        activityName.setText(localClassName);

        // Wyświetlamy wspólne preferencje.
        final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);
        prefs.setText(settings.getAll().toString());

        // Ustawiamy prywatne preferencje aktywności.
        final TextView prefsAct = (TextView)findViewById(R.id.CurrentActivityPrefs);
        prefsAct.setText(settingsActivity.getAll().toString());

        final Button goButton = (Button) findViewById(R.id.ButtonGo);
        if (localClassName.equals("SimplePreferencesActivity")) {
            // Przechodzimy do innej aktywności.
            goButton.setOnClickListener(new View.OnClickListener() {
                public void onClick(View v) {
                    // Przechodzimy do ekranu głównego.
                    Intent intent = new Intent(SuperSimplePreferencesActivity.this, GetTargetClass());
                    startActivity(intent);
                }
            });
        } else {
            goButton.setVisibility(View.INVISIBLE);
        }

        // OBSŁUGA PRZYCISKÓW PREFERENCJI AKTYWNOŚCI.
        // Obsługa kliknięć przycisków dodaj/aktualizuj.
        final Button prefAddActButton = (Button) findViewById(R.id.ButtonAddActivityPref);
        prefAddActButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
                final EditText prefValue = (EditText)findViewById(R.id.EditTextPrefValue);
                final TextView prefs = (TextView)findViewById(R.id.CurrentActivityPrefs);

                // Pobieramy ustawienia aplikacji i otwieramy edytor.
                SharedPreferences settings = getPreferences(0);
                SharedPreferences.Editor prefEditor = settings.edit();

                String strPrefName = prefName.getText().toString();
                String strPrefValue = prefValue.getText().toString();

                // Dodajemy preferencję i zatwierdzamy zmiany.
                prefEditor.putString(strPrefName, strPrefValue);
                prefEditor.apply();

                // Aktualizujemy ekran ze wszystkimi ustawieniami.
                prefs.setText(settings.getAll().toString());
            }
        });

        // Obsługa czyszczenia pojedycznej preferencji po kliknięciu nazyw.
        final Button clearActPrefByNameButton = (Button) findViewById(R.id.ButtonClearActPrefByName);
        clearActPrefByNameButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
                final TextView prefs = (TextView)findViewById(R.id.CurrentActivityPrefs);

                // Pobieramy ustawienia aplikacji i otwieramy edytor.
                SharedPreferences settings = getPreferences(0);
                SharedPreferences.Editor prefEditor = settings.edit();

                String strPrefName = prefName.getText().toString();

                // Usuwamy preferencję jeśli istnieje.
                if(settings.contains(strPrefName)) {
                    // Usuwamy istniejącą preferencję o tej samej nazwie.
                    prefEditor.remove(strPrefName);
                }

                // Zatwierdzamy zmiany i aktualizujemy ekran.
                prefEditor.apply();
                prefs.setText(settings.getAll().toString());
            }
        });

        // Obsługa kliknięć przycisku czyszczenia wszystkich preferencji.
        final Button clearButton = (Button) findViewById(R.id.ButtonClearAct);
        clearButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                final TextView prefs = (TextView)findViewById(R.id.CurrentActivityPrefs);

                // Pobieramy ustawienia aplikacji i otwieramy edytor.
                SharedPreferences settings = getPreferences(0);
                SharedPreferences.Editor prefEditor = settings.edit();

                // Usuwamy wszystkie preferencje.
                prefEditor.clear();
                prefEditor.apply();

                // Aktualizujemy ekran.
                prefs.setText(settings.getAll().toString());

                // Informujemy użytkownika o wykonenej operacji.
                Toast.makeText(SuperSimplePreferencesActivity.this, "Usunięto preferencje aktywności", Toast.LENGTH_SHORT).show();
            }
        });

        // OBSŁUGA PRZYCISKÓW WSPÓLNYCH PREFERENCJI
        // Obsługa kliknięć przycisków dodawania lub modyfikacji preferencji.
        final Button prefButton = (Button) findViewById(R.id.ButtonAddSharedPref);
        prefButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {


                final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
                final EditText prefValue = (EditText)findViewById(R.id.EditTextPrefValue);
                final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);

                // Pobieramy ustawienia aplikacji i otwieramy edytor.
                SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
                SharedPreferences.Editor prefEditor = settings.edit();

                String strPrefName = prefName.getText().toString();
                String strPrefValue = prefValue.getText().toString();

                // Dodajemy preferencje i zatwierdzamy zmiany.
                prefEditor.putString(strPrefName, strPrefValue);
                prefEditor.apply();

                // Aktualizujemy ekran z ustawieniami.
                prefs.setText(settings.getAll().toString());

            }
        });

        // Obsługa czyszczenia pojedynczej preferencji o wybranej nazwie.
        final Button clearPrefByNameButton = (Button) findViewById(R.id.ButtonClearSharedPrefByName);
        clearPrefByNameButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {

                final EditText prefName = (EditText)findViewById(R.id.EditTextPrefName);
                final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);

                // Pobieramy ustawienia aplikacji i otwieramy edytor.
                SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
                SharedPreferences.Editor prefEditor = settings.edit();

                String strPrefName = prefName.getText().toString();

                // Usuwamy preferencję jeśli istnieje.
                if(settings.contains(strPrefName)) {
                    // Usuwamy istniejącą preferencję o tej samej nazwie.
                    prefEditor.remove(strPrefName);
                }

                // Zatwierdzamy zmiany i aktualizujemy ekran.
                prefEditor.apply();
                prefs.setText(settings.getAll().toString());
            }
        });

        // Obsługa kliknięć przycisku czyszczenia preferencji.
        final Button clearSharedButton = (Button) findViewById(R.id.ButtonClearShared);
        clearSharedButton.setOnClickListener(new View.OnClickListener() {
            public void onClick(View v) {
                final TextView prefs = (TextView)findViewById(R.id.CurrentPrefs);

                // Pobieramy ustawienia aplikacji i otwieramy edytor.
                SharedPreferences settings = getSharedPreferences(PREFERENCE_FILENAME, 0);
                SharedPreferences.Editor prefEditor = settings.edit();

                // Usuwamy wszystkie preferencje.
                prefEditor.clear();
                prefEditor.apply();

                // Aktualizujemy ekran.
                prefs.setText(settings.getAll().toString());

                // Informujemy użytkownika o wykonanej operacji.
                Toast.makeText(SuperSimplePreferencesActivity.this, "Usunięto wspólne preferencje.", Toast.LENGTH_SHORT).show();
            }
        });

        // Rejetrujemy obiekt nasłuchujący, aby dostawać informacje o zmianach preferencji.
        settings.registerOnSharedPreferenceChangeListener(new SharedPreferences.OnSharedPreferenceChangeListener() {
            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                // Informujemy użytkownika o tym co się zmieniło.
                Toast.makeText(SuperSimplePreferencesActivity.this, "Wartość preferencji uległa zmianie: "+key, Toast.LENGTH_SHORT).show();
            }
        });
    }

    abstract Class<?> GetTargetClass();

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_super_simple_preferences, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
